// custom_formatInformationSectionMessage :
// tagSection : <desktop>, <interaction-information>, ...
// returns : "##### <desktop> #####\n"
function custom_formatInformationSectionMessage(tagSection) {
  return ("##### " + tagSection + " #####\n");
}


// custom_formatInformationFunctionMessage :
// tagFunction : <onload>, <onunload>, ...
// returns : "\n... <onload> ... \n"
function custom_formatInformationFunctionMessage(tagFunction) {
  return ("... " + tagFunction + " ... \n");
}


// custom_formatErrorMessage :
// variableName : userName, idInteraction, ...
// errorMessage : return from getErrorMessage or testVariable
// returns : "userName is undefined\n"
function custom_formatErrorMessage(variableName, error) {
  return (variableName + " " + error + "\n");
}


// testVariable :
// variableName : variable name to test for exemple "userName"
// variableValue : variable value to test
// returns : "" if no error, a formated message with the valiable name and the error if the variable is undefined or null
function custom_testVariable(variableName, variableValue) {
  if (variableValue === undefined)
    return custom_formatErrorMessage(variableName, " :: undefined");
  return "";
}


// custom_getErrorMessage :
// variableName : variable name 
// error : catched error
// returns : a formated message containing the variable name, the error and the error description
function custom_getErrorMessage(variableName, error) {
  return custom_formatErrorMessage(variableName, (" >> " + error.description));
}


function custom_testTest() {
  var strError = "";
  // test
  try {
    strError += custom_testVariable("TEST", test);
  } catch (error) {
    strError += custom_getErrorMessage("TEST", error);
  }
  return strError;
}


function custom_testUserName() {
  var strError = "";
  // userName
  try {
    strError += custom_testVariable("userName", userName);
  } catch (error) {
    strError += custom_getErrorMessage("userName", error);
  }
  return strError;
}


function custom_testIsSupervisor() {
  var strError = "";
  // isSupervisor()
  try {
    strError += custom_testVariable("isSupervisor", isSupervisor);
  } catch (error) {
    strError += custom_getErrorMessage("isSupervisor", error);
  }
  return strError;
}


function custom_testIdInteraction() {
  var strError = "";
  // idInteraction
  try {
    strError += custom_testVariable("idInteraction", idInteraction);
  } catch (error) {
    strError += custom_getErrorMessage("idInteraction", error);
  }
  return strError;
}


function custom_testInteractionType() {
  var strError = "";
  // interactionType
  try {
    strError += custom_testVariable("interactionType", interactionType);
  } catch (error) {
    strError += custom_getErrorMessage("interactionType", error);
  }
  strError += custom_testInteractionTypeConstants();
  return strError;
}


function custom_testInteractionTypeConstants() {
  var strError = "";
  // INTERACTION_VOICE
  try {
    strError += custom_testVariable("INTERACTION_VOICE", INTERACTION_VOICE);
  } catch (error) {
    strError += custom_getErrorMessage("INTERACTION_VOICE", error);
  }
  // INTERACTION_EMAIL
  try {
    strError += custom_testVariable("INTERACTION_EMAIL", INTERACTION_EMAIL);
  } catch (error) {
    strError += custom_getErrorMessage("INTERACTION_EMAIL", error);
  }
  // INTERACTION_CHAT
  try {
    strError += custom_testVariable("INTERACTION_CHAT", INTERACTION_CHAT);
  } catch (error) {
    strError += custom_getErrorMessage("INTERACTION_CHAT", error);
  }
  // INTERACTION_OPEN_MEDIA
  try {
    strError += custom_testVariable("INTERACTION_OPEN_MEDIA", INTERACTION_OPEN_MEDIA);
  } catch (error) {
    strError += custom_getErrorMessage("INTERACTION_OPEN_MEDIA", error);
  }
  // INTERACTION_IM
  try {
    strError += custom_testVariable("INTERACTION_IM", INTERACTION_IM);
  } catch (error) {
    strError += custom_getErrorMessage("INTERACTION_IM", error);
  }
  // INTERACTION_SMS_SESSION
  try {
    strError += custom_testVariable("INTERACTION_SMS_SESSION", INTERACTION_SMS_SESSION);
  } catch (error) {
    strError += custom_getErrorMessage("INTERACTION_SMS_SESSION", error);
  }
  // INTERACTION_IM
  try {
    strError += custom_testVariable("INTERACTION_WEB_CALLBACK", INTERACTION_WEB_CALLBACK);
  } catch (error) {
    strError += custom_getErrorMessage("INTERACTION_WEB_CALLBACK", error);
  }
  return strError;
}


function custom_testInteractionSubtype() {
  var strError = "";
  // interactionSubtype
  try {
    strError += custom_testVariable("interactionSubtype", interactionSubtype);
  } catch (error) {
    strError += custom_getErrorMessage("interactionSubtype", error);
  }
  strError += custom_testInteractionSubtypeConstants();
  return strError;
}


function custom_testInteractionSubtypeConstants() {
  var strError = "";
  // INTERACTION_COLLABORATION_INVITATION_IN
  try {
    strError += custom_testVariable("INTERACTION_COLLABORATION_INVITATION_IN", INTERACTION_COLLABORATION_INVITATION_IN);
  } catch (error) {
    strError += custom_getErrorMessage("INTERACTION_COLLABORATION_INVITATION_IN", error);
  }
  // INTERACTION_COLLABORATION_REPLY_OUT
  try {
    strError += custom_testVariable("INTERACTION_COLLABORATION_REPLY_OUT", INTERACTION_COLLABORATION_REPLY_OUT);
  } catch (error) {
    strError += custom_getErrorMessage("INTERACTION_COLLABORATION_REPLY_OUT", error);
  }
  // INTERACTION_EMAIL_IN
  try {
    strError += custom_testVariable("INTERACTION_EMAIL_IN", INTERACTION_EMAIL_IN);
  } catch (error) {
    strError += custom_getErrorMessage("INTERACTION_EMAIL_IN", error);
  }
  // INTERACTION_EMAIL_OUT
  try {
    strError += custom_testVariable("INTERACTION_EMAIL_OUT", INTERACTION_EMAIL_OUT);
  } catch (error) {
    strError += custom_getErrorMessage("INTERACTION_EMAIL_OUT", error);
  }
  // INTERACTION_KW
  try {
    strError += custom_testVariable("INTERACTION_KW", INTERACTION_KW);
  } catch (error) {
    strError += custom_getErrorMessage("INTERACTION_KW", error);
  }
  // INTERACTION_KW_PREVIEW
  try {
    strError += custom_testVariable("INTERACTION_KW_PREVIEW", INTERACTION_KW_PREVIEW);
  } catch (error) {
    strError += custom_getErrorMessage("INTERACTION_KW_PREVIEW", error);
  }
  // INTERACTION_SIP_PREVIEW
  try {
    strError += custom_testVariable("INTERACTION_SIP_PREVIEW", INTERACTION_SIP_PREVIEW);
  } catch (error) {
    strError += custom_getErrorMessage("INTERACTION_SIP_PREVIEW", error);
  }
  // INTERACTION_VOICE_OUTBOUND
  try {
    strError += custom_testVariable("INTERACTION_VOICE_OUTBOUND", INTERACTION_VOICE_OUTBOUND);
  } catch (error) {
    strError += custom_getErrorMessage("INTERACTION_VOICE_OUTBOUND", error);
  }
  // INTERACTION_VOICE_CALLBACK
  try {
    strError += custom_testVariable("INTERACTION_VOICE_CALLBACK", INTERACTION_VOICE_CALLBACK);
  } catch (error) {
    strError += custom_getErrorMessage("INTERACTION_VOICE_CALLBACK", error);
  }
  // NOT_APPLICABLE
  try {
    strError += custom_testVariable("NOT_APPLICABLE", NOT_APPLICABLE);
  } catch (error) {
    strError += custom_getErrorMessage("NOT_APPLICABLE", error);
  }
  return strError;
}


function custom_testInteractionOpenMediaType() {
  var strError = "";
  // openMediaType
  try {
    strError += custom_testVariable("openMediaType", openMediaType);
  } catch (error) {
    strError += custom_getErrorMessage("openMediaType", error);
  }
  return strError;
}


function custom_testInteractionOpenInteractionType() {
  var strError = "";
  // openInteractionType
  try {
    strError += custom_testVariable("openInteractionType", openInteractionType);
  } catch (error) {
    strError += custom_getErrorMessage("openInteractionType", error);
  }
  return strError;
}


function custom_testInteractionOpenInteractionSubtype() {
  var strError = "";
  // openInteractionSubtype
  try {
    strError += custom_testVariable("openInteractionSubtype", openInteractionSubtype);
  } catch (error) {
    strError += custom_getErrorMessage("openInteractionSubtype", error);
  }
  return strError;
}


function custom_testInteractionStatus() {
  var strError = "";
  // interactionStatus
  try {
    strError += custom_testVariable("interactionStatus", interactionStatus);
  } catch (error) {
    strError += custom_getErrorMessage("interactionStatus", error);
  }
  strError += custom_testInteractionStatusConstants();
  return strError;
}


function custom_testInteractionStatusConstants() {
  var strError = "";
  // STATUS_IDLE
  try {
    strError += custom_testVariable("STATUS_IDLE", STATUS_IDLE);
  } catch (error) {
    strError += custom_getErrorMessage("STATUS_IDLE", error);
  }
  // STATUS_DIALING
  try {
    strError += custom_testVariable("STATUS_DIALING", STATUS_DIALING);
  } catch (error) {
    strError += custom_getErrorMessage("STATUS_DIALING", error);
  }
  // STATUS_TALKING
  try {
    strError += custom_testVariable("STATUS_TALKING", STATUS_TALKING);
  } catch (error) {
    strError += custom_getErrorMessage("STATUS_TALKING", error);
  }
  // STATUS_RINGING
  try {
    strError += custom_testVariable("STATUS_RINGING", STATUS_RINGING);
  } catch (error) {
    strError += custom_getErrorMessage("STATUS_RINGING", error);
  }
  // STATUS_HELD
  try {
    strError += custom_testVariable("STATUS_HELD", STATUS_HELD);
  } catch (error) {
    strError += custom_getErrorMessage("STATUS_HELD", error);
  }
  // STATUS_NEW
  try {
    strError += custom_testVariable("STATUS_NEW", STATUS_NEW);
  } catch (error) {
    strError += custom_getErrorMessage("STATUS_NEW", error);
  }
  return strError;
}


function custom_testIdContact() {
  var strError = "";
  // idContact
  try {
    strError += custom_testVariable("idContact", idContact);
  } catch (error) {
    strError += custom_getErrorMessage("idContact", error);
  }
  return strError;
}


function custom_testInteractionVariables(idInteractionTest, interactionTypeTest, interactionSubtypeTest, interactionOpenMediaVariables, interactionStatusTest, idContactTest) {
  var strError = "";
  // idInteraction
  if (idInteractionTest)
    strError += custom_testIdInteraction();

  // interactionType : INTERACTION_VOICE, INTERACTION_EMAIL, INTERACTION_CHAT, INTERACTION_OPEN_MEDIA, INTERACTION_IM, INTERACTION_SMS_SESSION, INTERACTION_WEB_CALLBACK
  if (interactionTypeTest)
    strError += custom_testInteractionType();

  // interactionSubtype : INTERACTION_COLLABORATION_INVITATION_IN, INTERACTION_COLLABORATION_REPLY_OUT, INTERACTION_EMAIL_IN, INTERACTION_EMAIL_OUT,
  //                      INTERACTION_KW, INTERACTION_KW_PREVIEW, INTERACTION_SIP_PREVIEW, INTERACTION_VOICE_OUTBOUND, INTERACTION_VOICE_CALLBACK, NOT_APPLICABLE
  if (interactionSubtypeTest)
    strError += custom_testInteractionSubtype();

  if (interactionOpenMediaVariables) {
    strError += custom_testInteractionOpenMediaType();
    strError += custom_testInteractionOpenInteractionType();
    strError += custom_testInteractionOpenInteractionSubtype();
  }

  // interactionStatus : STATUS_IDLE, STATUS_DIALING, STATUS_TALKING, STATUS_RINGING, STATUS_HELD, STATUS_NEW
  if (interactionStatusTest)
    strError += custom_testInteractionStatus();

  // idContact
  if (idContactTest)
    strError += custom_testIdContact();

  return strError;
}


function custom_testCustomContextFunctions() {
  var strError = "";
  // getCustomContext()
  try {
    strError += custom_testVariable("getCustomContext", getCustomContext);
  } catch (error) {
    strError += custom_getErrorMessage("getCustomContext", error);
  }

  // selectTabByName(tabName)
  try {
    strError += custom_testVariable("setCustomContext", setCustomContext);
  } catch (error) {
    strError += custom_getErrorMessage("setCustomContext", error);
  }

  return strError;
}


function custom_testCustomEvent() {
  var strError = "";
  // customEvent
  try {
    strError += custom_testVariable("customEvent[0]", customEvent[0]);
  } catch (error) {
    strError += custom_getErrorMessage("customEvent[0]", error);
  }
  return strError;
}


function custom_testButtonFunctions() {
  var strError = "";
  // enableButton(buttonName)
  try {
    strError += custom_testVariable("enableButton", enableButton);
  } catch (error) {
    strError += custom_getErrorMessage("enableButton", error);
  }

  // disableButton(buttonName)
  try {
    strError += custom_testVariable("disableButton", disableButton);
  } catch (error) {
    strError += custom_getErrorMessage("disableButton", error);
  }
  return strError;
}


function custom_testCentralPanelFunctions() {
  var strError = "";
  // openCentralPanel()
  try {
    strError += custom_testVariable("openCentralPanel", openCentralPanel);
  } catch (error) {
    strError += custom_getErrorMessage("openCentralPanel", error);
  }

  // closeCentralPanel()
  try {
    strError += custom_testVariable("closeCentralPanel", closeCentralPanel);
  } catch (error) {
    strError += custom_getErrorMessage("closeCentralPanel", error);
  }
  return strError;
}


function custom_testTabAreaFunctions(areaName) {
  var strError = "";
  // selectTabByName(tabName)
  try {
    strError += custom_testVariable("selectTabByName", selectTabByName);
  } catch (error) {
    strError += custom_getErrorMessage("selectTabByName", error);
  }

  // hideTabByName(tabName)
  try {
    strError += custom_testVariable("hideTabByName", hideTabByName);
  } catch (error) {
    strError += custom_getErrorMessage("hideTabByName", error);
  }

  switch (areaName) {
    case "interaction-information" :
      // TAB_INTERACTION_INFORMATION_AUTOSUGGEST
      try {
        strError += custom_testVariable("TAB_INTERACTION_INFORMATION_AUTOSUGGEST", TAB_INTERACTION_INFORMATION_AUTOSUGGEST);
      } catch (error) {
        strError += custom_getErrorMessage("TAB_INTERACTION_INFORMATION_AUTOSUGGEST", error);
      }

      // TAB_INTERACTION_INFORMATION_NOTEPAD
      try {
        strError += custom_testVariable("TAB_INTERACTION_INFORMATION_NOTEPAD", TAB_INTERACTION_INFORMATION_NOTEPAD);
      } catch (error) {
        strError += custom_getErrorMessage("TAB_INTERACTION_INFORMATION_NOTEPAD", error);
      }

      // TAB_INTERACTION_INFORMATION_ATTACHED_DATA
      try {
        strError += custom_testVariable("TAB_INTERACTION_INFORMATION_ATTACHED_DATA", TAB_INTERACTION_INFORMATION_ATTACHED_DATA);
      } catch (error) {
        strError += custom_getErrorMessage("TAB_INTERACTION_INFORMATION_ATTACHED_DATA", error);
      }

      // TAB_INTERACTION_INFORMATION_CUSTOM_ATTACHED_DATA
      try {
        strError += custom_testVariable("TAB_INTERACTION_INFORMATION_CUSTOM_ATTACHED_DATA", TAB_INTERACTION_INFORMATION_CUSTOM_ATTACHED_DATA);
      } catch (error) {
        strError += custom_getErrorMessage("TAB_INTERACTION_INFORMATION_CUSTOM_ATTACHED_DATA", error);
      }

      // TAB_INTERACTION_INFORMATION_CAMPAIGN
      try {
        strError += custom_testVariable("TAB_INTERACTION_INFORMATION_CAMPAIGN", TAB_INTERACTION_INFORMATION_CAMPAIGN);
      } catch (error) {
        strError += custom_getErrorMessage("TAB_INTERACTION_INFORMATION_CAMPAIGN", error);
      }

      // TAB_INTERACTION_INFORMATION_DISPOSITION_CODE
      try {
        strError += custom_testVariable("TAB_INTERACTION_INFORMATION_DISPOSITION_CODE", TAB_INTERACTION_INFORMATION_DISPOSITION_CODE);
      } catch (error) {
        strError += custom_getErrorMessage("TAB_INTERACTION_INFORMATION_DISPOSITION_CODE", error);
      }

      // TAB_INTERACTION_INFORMATION_CALLBACK (plus maintenant mais faut le laisser!)
      try {
        strError += custom_testVariable("TAB_INTERACTION_INFORMATION_CALLBACK", TAB_INTERACTION_INFORMATION_CALLBACK);
      } catch (error) {
        strError += custom_getErrorMessage("TAB_INTERACTION_INFORMATION_CALLBACK", error);
      }
      break;

    case "resources" :
      // TAB_RESOURCES_SRL
      try {
        strError += custom_testVariable("TAB_RESOURCES_SRL", TAB_RESOURCES_SRL);
      } catch (error) {
        strError += custom_getErrorMessage("TAB_RESOURCES_SRL", error);
      }

      // TAB_RESOURCES_FAVORITES
      try {
        strError += custom_testVariable("TAB_RESOURCES_FAVORITES", TAB_RESOURCES_FAVORITES);
      } catch (error) {
        strError += custom_getErrorMessage("TAB_RESOURCES_FAVORITES", error);
      }
      break;

    case "customer-records" :
      // TAB_CUSTOMER_RECORDS_CONTACT
      try {
        strError += custom_testVariable("TAB_CUSTOMER_RECORDS_CONTACT", TAB_CUSTOMER_RECORDS_CONTACT);
      } catch (error) {
        strError += custom_getErrorMessage("TAB_CUSTOMER_RECORDS_CONTACT", error);
      }

      // TAB_CUSTOMER_RECORDS_HISTORY
      try {
        strError += custom_testVariable("TAB_CUSTOMER_RECORDS_HISTORY", TAB_CUSTOMER_RECORDS_HISTORY);
      } catch (error) {
        strError += custom_getErrorMessage("TAB_CUSTOMER_RECORDS_HISTORY", error);
      }

      // TAB_CUSTOMER_RECORDS_COLLABORATI0N
      try {
        strError += custom_testVariable("TAB_CUSTOMER_RECORDS_COLLABORATI0N", TAB_CUSTOMER_RECORDS_COLLABORATI0N);
      } catch (error) {
        strError += custom_getErrorMessage("TAB_CUSTOMER_RECORDS_COLLABORATI0N", error);
      }

      // TAB_CUSTOMER_RECORDS_OUTBOUND
      try {
        strError += custom_testVariable("TAB_CUSTOMER_RECORDS_OUTBOUND", TAB_CUSTOMER_RECORDS_OUTBOUND);
      } catch (error) {
        strError += custom_getErrorMessage("TAB_CUSTOMER_RECORDS_OUTBOUND", error);
      }

      // TAB_CUSTOMER_RECORDS_OUTBOUND_CHAINED_RECORDS
      try {
        strError += custom_testVariable("TAB_CUSTOMER_RECORDS_OUTBOUND_CHAINED_RECORDS", TAB_CUSTOMER_RECORDS_OUTBOUND_CHAINED_RECORDS);
      } catch (error) {
        strError += custom_getErrorMessage("TAB_CUSTOMER_RECORDS_OUTBOUND_CHAINED_RECORDS", error);
      }

      // TAB_CUSTOMER_RECORDS_OUTBOUND_RESCHEDULE
      try {
        strError += custom_testVariable("TAB_CUSTOMER_RECORDS_OUTBOUND_RESCHEDULE", TAB_CUSTOMER_RECORDS_OUTBOUND_RESCHEDULE);
      } catch (error) {
        strError += custom_getErrorMessage("TAB_CUSTOMER_RECORDS_OUTBOUND_RESCHEDULE", error);
      }

      // TAB_CUSTOMER_RECORDS_CALLBACK
      try {
        strError += custom_testVariable("TAB_CUSTOMER_RECORDS_CALLBACK", TAB_CUSTOMER_RECORDS_CALLBACK);
      } catch (error) {
        strError += custom_getErrorMessage("TAB_CUSTOMER_RECORDS_CALLBACK", error);
      }

      // TAB_CUSTOMER_RECORDS_MERGE_CONTACT_DETAIL
      try {
        strError += custom_testVariable("TAB_CUSTOMER_RECORDS_MERGE_CONTACT_DETAIL", TAB_CUSTOMER_RECORDS_MERGE_CONTACT_DETAIL);
      } catch (error) {
        strError += custom_getErrorMessage("TAB_CUSTOMER_RECORDS_MERGE_CONTACT_DETAIL", error);
      }
      break;
  }
  return strError;
}


function custom_testTabFunctions(areaName) {
  var strError = "";
  // getDetailFrameName()
  try {
    strError += custom_testVariable("getDetailFrameName", getDetailFrameName);
  } catch (error) {
    strError += custom_getErrorMessage("getDetailFrameName", error);
  }
  strError += custom_testTabAreaFunctions(areaName);
  return strError;
}


function custom_testMenuBarItemsFunctions() {
  var strError = "";
  // enableMenuBarItemByName(menuItem)
  try {
    strError += custom_testVariable("enableMenuBarItemByName", enableMenuBarItemByName);
  } catch (error) {
    strError += custom_getErrorMessage("enableMenuBarItemByName", error);
  }
  // disableMenuBarItemByName(menuItem)
  try {
    strError += custom_testVariable("disableMenuBarItemByName", disableMenuBarItemByName);
  } catch (error) {
    strError += custom_getErrorMessage("disableMenuBarItemByName", error);
  }
  // hideMenuBarItemByName(menuItem)
  try {
    strError += custom_testVariable("hideMenuBarItemByName", hideMenuBarItemByName);
  } catch (error) {
    strError += custom_getErrorMessage("hideMenuBarItemByName", error);
  }
  // checkMenuBarItemByName(menuItem)
  try {
    strError += custom_testVariable("checkMenuBarItemByName", checkMenuBarItemByName);
  } catch (error) {
    strError += custom_getErrorMessage("checkMenuBarItemByName", error);
  }
  // uncheckMenuBarItemByName(menuItem)
  try {
    strError += custom_testVariable("uncheckMenuBarItemByName", uncheckMenuBarItemByName);
  } catch (error) {
    strError += custom_getErrorMessage("uncheckMenuBarItemByName", error);
  }


  // MENU_ITEM_READY
  try {
    strError += custom_testVariable("MENU_ITEM_READY", MENU_ITEM_READY);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_READY", error);
  }
  // MENU_ITEM_NOT_READY
  try {
    strError += custom_testVariable("MENU_ITEM_NOT_READY", MENU_ITEM_NOT_READY);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_NOT_READY", error);
  }
  // MENU_ITEM_NOT_READY_WITH_ACTION_CODE
  try {
    strError += custom_testVariable("MENU_ITEM_NOT_READY_WITH_ACTION_CODE", MENU_ITEM_NOT_READY_WITH_ACTION_CODE);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_NOT_READY_WITH_ACTION_CODE", error);
  }
  // MENU_ITEM_AFTER_CALL_WORK
  try {
    strError += custom_testVariable("MENU_ITEM_AFTER_CALL_WORK", MENU_ITEM_AFTER_CALL_WORK);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_AFTER_CALL_WORK", error);
  }

  // MENU_ITEM_AGENT_PLACE_STATUS
  try {
    strError += custom_testVariable("MENU_ITEM_AGENT_PLACE_STATUS", MENU_ITEM_AGENT_PLACE_STATUS);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_AGENT_PLACE_STATUS", error);
  }
  // MENU_ITEM_NEW_PHONE_CALL
  try {
    strError += custom_testVariable("MENU_ITEM_NEW_PHONE_CALL", MENU_ITEM_NEW_PHONE_CALL);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_NEW_PHONE_CALL", error);
  }
  // MENU_ITEM_RE_DIAL
  try {
    strError += custom_testVariable("MENU_ITEM_RE_DIAL", MENU_ITEM_RE_DIAL);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_RE_DIAL", error);
  }
  // MENU_ITEM_SPEED_DIAL
  try {
    strError += custom_testVariable("MENU_ITEM_SPEED_DIAL", MENU_ITEM_SPEED_DIAL);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_SPEED_DIAL", error);
  }
  // MENU_ITEM_FORWARD
  try {
    strError += custom_testVariable("MENU_ITEM_FORWARD", MENU_ITEM_FORWARD);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_FORWARD", error);
  }
  // MENU_ITEM_CANCEL_FORWARD
  try {
    strError += custom_testVariable("MENU_ITEM_CANCEL_FORWARD", MENU_ITEM_CANCEL_FORWARD);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_CANCEL_FORWARD", error);
  }
  // MENU_ITEM_DND_ON
  try {
    strError += custom_testVariable("MENU_ITEM_DND_ON", MENU_ITEM_DND_ON);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_DND_ON", error);
  }
  // MENU_ITEM_DND_OFF
  try {
    strError += custom_testVariable("MENU_ITEM_DND_OFF", MENU_ITEM_DND_OFF);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_DND_OFF", error);
  }
  // MENU_ITEM_ON_CALL
  try {
    strError += custom_testVariable("MENU_ITEM_ON_CALL", MENU_ITEM_ON_CALL);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_ON_CALL", error);
  }
  // MENU_ITEM_NEW_EMAIL
  try {
    strError += custom_testVariable("MENU_ITEM_NEW_EMAIL", MENU_ITEM_NEW_EMAIL);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_NEW_EMAIL", error);
  }
  // MENU_ITEM_NEW_IM
  try {
    strError += custom_testVariable("MENU_ITEM_NEW_IM", MENU_ITEM_NEW_IM);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_NEW_IM", error);
  }
  // MENU_ITEM_PRINT_PREVIEW
  try {
    strError += custom_testVariable("MENU_ITEM_PRINT_PREVIEW", MENU_ITEM_PRINT_PREVIEW);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_PRINT_PREVIEW", error);
  }
  // MENU_ITEM_LOGIN
  try {
    strError += custom_testVariable("MENU_ITEM_LOGIN", MENU_ITEM_LOGIN);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_LOGIN", error);
  }
  // MENU_ITEM_LOGOUT
  try {
    strError += custom_testVariable("MENU_ITEM_LOGOUT", MENU_ITEM_LOGOUT);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_LOGOUT", error);
  }
  // MENU_ITEM_CAMPAIGNS
  try {
    strError += custom_testVariable("MENU_ITEM_CAMPAIGNS", MENU_ITEM_CAMPAIGNS);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_CAMPAIGNS", error);
  }
  // MENU_ITEM_NEXT_CAMPAIGN_CONTACT
  try {
    strError += custom_testVariable("MENU_ITEM_NEXT_CAMPAIGN_CONTACT", MENU_ITEM_NEXT_CAMPAIGN_CONTACT);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_NEXT_CAMPAIGN_CONTACT", error);
  }
  // MENU_ITEM_TOOL_BAR
  try {
    strError += custom_testVariable("MENU_ITEM_TOOL_BAR", MENU_ITEM_TOOL_BAR);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_TOOL_BAR", error);
  }
  // MENU_ITEM_STATUS_BAR
  try {
    strError += custom_testVariable("MENU_ITEM_STATUS_BAR", MENU_ITEM_STATUS_BAR);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_STATUS_BAR", error);
  }
  // MENU_ITEM_STATISTIC_BAR
  try {
    strError += custom_testVariable("MENU_ITEM_STATISTIC_BAR", MENU_ITEM_STATISTIC_BAR);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_STATISTIC_BAR", error);
  }
  // MENU_ITEM_SETTINGS
  try {
    strError += custom_testVariable("MENU_ITEM_SETTINGS", MENU_ITEM_SETTINGS);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_SETTINGS", error);
  }
  // MENU_ITEM_WORK_AREA
  try {
    strError += custom_testVariable("MENU_ITEM_WORK_AREA", MENU_ITEM_WORK_AREA);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_WORK_AREA", error);
  }
  // MENU_ITEM_QUICK_DASHBOARD
  try {
    strError += custom_testVariable("MENU_ITEM_QUICK_DASHBOARD", MENU_ITEM_QUICK_DASHBOARD);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_QUICK_DASHBOARD", error);
  }
  // MENU_ITEM_ALARM_INDICATION_ICONS
  try {
    strError += custom_testVariable("MENU_ITEM_ALARM_INDICATION_ICONS", MENU_ITEM_ALARM_INDICATION_ICONS);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_ALARM_INDICATION_ICONS", error);
  }
  // MENU_ITEM_SUPERVISOR_SETTINGS
  try {
    strError += custom_testVariable("MENU_ITEM_SUPERVISOR_SETTINGS", MENU_ITEM_SUPERVISOR_SETTINGS);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_SUPERVISOR_SETTINGS", error);
  }
  // MENU_ITEM_VIEW_PROFILE_TEMPLATES
  try {
    strError += custom_testVariable("MENU_ITEM_VIEW_PROFILE_TEMPLATES", MENU_ITEM_VIEW_PROFILE_TEMPLATES);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_VIEW_PROFILE_TEMPLATES", error);
  }
  // MENU_ITEM_OBJECT_SETS
  try {
    strError += custom_testVariable("MENU_ITEM_OBJECT_SETS", MENU_ITEM_OBJECT_SETS);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_OBJECT_SETS", error);
  }
  // MENU_ITEM_VIEW_TEMPLATES
  try {
    strError += custom_testVariable("MENU_ITEM_VIEW_TEMPLATES", MENU_ITEM_VIEW_TEMPLATES);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_VIEW_TEMPLATES", error);
  }
  // MENU_ITEM_STATISTICS
  try {
    strError += custom_testVariable("MENU_ITEM_STATISTICS", MENU_ITEM_STATISTICS);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_STATISTICS", error);
  }
  // MENU_ITEM_MEDIA_LISTS
  try {
    strError += custom_testVariable("MENU_ITEM_MEDIA_LISTS", MENU_ITEM_MEDIA_LISTS);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_MEDIA_LISTS", error);
  }
  // MENU_ITEM_THRESHOLD_TEMPLATES
  try {
    strError += custom_testVariable("MENU_ITEM_THRESHOLD_TEMPLATES", MENU_ITEM_THRESHOLD_TEMPLATES);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_THRESHOLD_TEMPLATES_MENU_ITEM_NAME", error);
  }
  // MENU_ITEM_EMAIL_NOTIFICATION_LISTS
  try {
    strError += custom_testVariable("MENU_ITEM_EMAIL_NOTIFICATION_LISTS", MENU_ITEM_EMAIL_NOTIFICATION_LISTS);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_EMAIL_NOTIFICATION_LISTS", error);
  }
  // MENU_ITEM_ACTION_TEMPLATES
  try {
    strError += custom_testVariable("MENU_ITEM_ACTION_TEMPLATES", MENU_ITEM_ACTION_TEMPLATES);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_ACTION_TEMPLATES", error);
  }
  // MENU_ITEM_RELOAD_EXAMPLE_CUSTOMER_VIEWS
  try {
    strError += custom_testVariable("MENU_ITEM_RELOAD_EXAMPLE_CUSTOMER_VIEWS", MENU_ITEM_RELOAD_EXAMPLE_CUSTOMER_VIEWS);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_RELOAD_EXAMPLE_CUSTOMER_VIEWS", error);
  }
  // MENU_ITEM_SERVER_SETTINGS
  try {
    strError += custom_testVariable("MENU_ITEM_SERVER_SETTINGS", MENU_ITEM_SERVER_SETTINGS);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_SERVER_SETTINGS", error);
  }
  // MENU_ITEM_HELP_CONTENTS
  try {
    strError += custom_testVariable("MENU_ITEM_HELP_CONTENTS", MENU_ITEM_HELP_CONTENTS);
  } catch (error) {
    strError += custom_getErrorMessage("MENU_ITEM_HELP_CONTENTS", error);
  }
  // MENU_ITEM_ABOUT
  try {
    strError += custom_testVariable("MENU_ITEM_ABOUT", MENU_ITEM_ABOUT);
  } catch (error) {
    strError += custom_getErrorMessage("AMENU_ITEM_BOUT", error);
  }


  return strError;
}


function custom_testToolBarItemsFunctions() {
  var strError = "";
  // enableToolBarItemByName(toolbarItemName)
  try {
    strError += custom_testVariable("enableToolBarItemByName", enableToolBarItemByName);
  } catch (error) {
    strError += custom_getErrorMessage("enableToolBarItemByName", error);
  }
  // disableToolBarItemByName(toolbarItemName)
  try {
    strError += custom_testVariable("disableToolBarItemByName", disableToolBarItemByName);
  } catch (error) {
    strError += custom_getErrorMessage("disableToolBarItemByName", error);
  }
  // hideToolBarItemByName(toolbarItemName)
  try {
    strError += custom_testVariable("hideToolBarItemByName", hideToolBarItemByName);
  } catch (error) {
    strError += custom_getErrorMessage("hideToolBarItemByName", error);
  }


  // TOOL_BAR_ITEM_NEW_PHONE_CALL
  try {
    strError += custom_testVariable("TOOL_BAR_ITEM_NEW_PHONE_CALL", TOOL_BAR_ITEM_NEW_PHONE_CALL);
  } catch (error) {
    strError += custom_getErrorMessage("TOOL_BAR_ITEM_NEW_PHONE_CALL", error);
  }
  // TOOL_BAR_ITEM_NEW_IM
  try {
    strError += custom_testVariable("TOOL_BAR_ITEM_NEW_IM", TOOL_BAR_ITEM_NEW_IM);
  } catch (error) {
    strError += custom_getErrorMessage("TOOL_BAR_ITEM_NEW_IM", error);
  }
  // TOOL_BAR_ITEM_NEW_EMAIL
  try {
    strError += custom_testVariable("TOOL_BAR_ITEM_NEW_EMAIL", TOOL_BAR_ITEM_NEW_EMAIL);
  } catch (error) {
    strError += custom_getErrorMessage("TOOL_BAR_ITEM_NEW_EMAIL", error);
  }
  // TOOL_BAR_ITEM_FORWARD
  try {
    strError += custom_testVariable("TOOL_BAR_ITEM_FORWARD", TOOL_BAR_ITEM_FORWARD);
  } catch (error) {
    strError += custom_getErrorMessage("TOOL_BAR_ITEM_FORWARD", error);
  }
  // TOOL_BAR_ITEM_CANCEL_FORWARD
  try {
    strError += custom_testVariable("TOOL_BAR_ITEM_CANCEL_FORWARD", TOOL_BAR_ITEM_CANCEL_FORWARD);
  } catch (error) {
    strError += custom_getErrorMessage("TOOL_BAR_ITEM_CANCEL_FORWARD", error);
  }
  // TOOL_BAR_ITEM_DND_ON
  try {
    strError += custom_testVariable("TOOL_BAR_ITEM_DND_ON", TOOL_BAR_ITEM_DND_ON);
  } catch (error) {
    strError += custom_getErrorMessage("TOOL_BAR_ITEM_DND_ON", error);
  }
  // TOOL_BAR_ITEM_DND_OFF
  try {
    strError += custom_testVariable("TOOL_BAR_ITEM_DND_OFF", TOOL_BAR_ITEM_DND_OFF);
  } catch (error) {
    strError += custom_getErrorMessage("TOOL_BAR_ITEM_DND_OFF", error);
  }
  // TOOL_BAR_ITEM_ON_CALL
  try {
    strError += custom_testVariable("TOOL_BAR_ITEM_ON_CALL", TOOL_BAR_ITEM_ON_CALL);
  } catch (error) {
    strError += custom_getErrorMessage("TOOL_BAR_ITEM_ON_CALL", error);
  }
  // TOOL_BAR_ITEM_CAMPAINS
  try {
    strError += custom_testVariable("TOOL_BAR_ITEM_CAMPAINS", TOOL_BAR_ITEM_CAMPAINS);
  } catch (error) {
    strError += custom_getErrorMessage("TOOL_BAR_ITEM_CAMPAINS", error);
  }
  // TOOL_BAR_ITEM_LOGIN
  try {
    strError += custom_testVariable("TOOL_BAR_ITEM_LOGIN", TOOL_BAR_ITEM_LOGIN);
  } catch (error) {
    strError += custom_getErrorMessage("TOOL_BAR_ITEM_LOGIN", error);
  }
  // TOOL_BAR_ITEM_LOGOUT
  try {
    strError += custom_testVariable("TOOL_BAR_ITEM_LOGOUT", TOOL_BAR_ITEM_LOGOUT);
  } catch (error) {
    strError += custom_getErrorMessage("TOOL_BAR_ITEM_LOGOUT", error);
  }
  // TOOL_BAR_ITEM_HELP
  try {
    strError += custom_testVariable("TOOL_BAR_ITEM_HELP", TOOL_BAR_ITEM_HELP);
  } catch (error) {
    strError += custom_getErrorMessage("TOOL_BAR_ITEM_HELP", error);
  }


  return strError;
}


function custom_testToolBarItemFunctions() {
  var strError = "";
  // enableToolBarItem(toolbarItemName)
  try {
    strError += custom_testVariable("enableToolBarItem", enableToolBarItem);
  } catch (error) {
    strError += custom_getErrorMessage("enableToolBarItem", error);
  }
  // disableToolBarItem(toolbarItemName)
  try {
    strError += custom_testVariable("disableToolBarItem", disableToolBarItem);
  } catch (error) {
    strError += custom_getErrorMessage("disableToolBarItem", error);
  }
  return strError;
}


function custom_testShortcutsFunctions() {
  var strError = "";
  // enableShortcutByName(shortcutName)
  try {
    strError += custom_testVariable("enableShortcutByName", enableShortcutByName);
  } catch (error) {
    strError += custom_getErrorMessage("enableShortcutByName", error);
  }
  // disableShortcutByName(shortcutName)
  try {
    strError += custom_testVariable("disableShortcutByName", disableShortcutByName);
  } catch (error) {
    strError += custom_getErrorMessage("disableShortcutByName", error);
  }
  return strError;
}


function custom_testDisplayBarMessageFunctions() {
  var strError = "";
  // showWarningMessage(messageText)
  try {
    strError += custom_testVariable("showWarningMessage", showWarningMessage);
  } catch (error) {
    strError += custom_getErrorMessage("showWarningMessage", error);
  }
  // showInformationMessage(messageText)
  try {
    strError += custom_testVariable("showInformationMessage", showInformationMessage);
  } catch (error) {
    strError += custom_getErrorMessage("showInformationMessage", error);
  }
  return strError;
}


function custom_testCustomAreasFunctions() {
  var strError = "";
  // showCustomArea(areaId)
  try {
    strError += custom_testVariable("showCustomArea", showCustomArea);
  } catch (error) {
    strError += custom_getErrorMessage("showCustomArea", error);
  }
  // hideCustomArea(areaId)
  try {
    strError += custom_testVariable("hideCustomArea", hideCustomArea);
  } catch (error) {
    strError += custom_getErrorMessage("hideCustomArea", error);
  }
  // setCustomAreaSize(areaId, size)
  try {
    strError += custom_testVariable("setCustomAreaSize", setCustomAreaSize);
  } catch (error) {
    strError += custom_getErrorMessage("setCustomAreaSize", error);
  }
  // getCustomAreaFrameName(areaId)
  try {
    strError += custom_testVariable("getCustomAreaFrameName", getCustomAreaFrameName);
  } catch (error) {
    strError += custom_getErrorMessage("getCustomAreaFrameName", error);
  }


  // CUSTOM_AREA_TOP
  try {
    strError += custom_testVariable("CUSTOM_AREA_TOP", CUSTOM_AREA_TOP);
  } catch (error) {
    strError += custom_getErrorMessage("CUSTOM_AREA_TOP", error);
  }
  // CUSTOM_AREA_RIGHT
  try {
    strError += custom_testVariable("CUSTOM_AREA_RIGHT", CUSTOM_AREA_RIGHT);
  } catch (error) {
    strError += custom_getErrorMessage("CUSTOM_AREA_RIGHT", error);
  }
  // CUSTOM_AREA_BOTTOM
  try {
    strError += custom_testVariable("CUSTOM_AREA_BOTTOM", CUSTOM_AREA_BOTTOM);
  } catch (error) {
    strError += custom_getErrorMessage("CUSTOM_AREA_BOTTOM", error);
  }

  return strError;
}


function custom_testFunction(testObject, idxFunction) {
  if (testObject.functions[idxFunction] != "true") {
    var functionReport = "";
    var idContactTest = false;
    var interactionStatusTest = true;

    functionReport += custom_testUserName();
    functionReport += custom_testIsSupervisor();

    switch(testObject.name) {
      case "desktop":
        switch (testObject.functions[idxFunction]) {
          case "onaddinteraction" :
          case "onremoveinteraction" :
            interactionStatusTest = false;
          case "onselectinteraction" :
          case "oninteractionstatuschange" :
            functionReport += custom_testInteractionVariables(true, true, true, true, interactionStatusTest, true);
            break;
          case "oncustomevent" :
            functionReport += custom_testCustomEvent();
            break;
        }
        functionReport += custom_testCentralPanelFunctions();
        functionReport += custom_testDisplayBarMessageFunctions();
        functionReport += custom_testCustomAreasFunctions();
        break;
      case "menu-bar":
        functionReport += custom_testMenuBarItemsFunctions();
        functionReport += custom_testCentralPanelFunctions();
        functionReport += custom_testDisplayBarMessageFunctions();
        functionReport += custom_testCustomAreasFunctions();
        break;
      case "tool-bar":
        functionReport += custom_testToolBarItemsFunctions();
        functionReport += custom_testCentralPanelFunctions();
        functionReport += custom_testDisplayBarMessageFunctions();
        functionReport += custom_testCustomAreasFunctions();
        break;
      case "interaction-action" :
        if (testObject.functions[idxFunction] == "oncustomevent") {
          functionReport += custom_testCustomEvent();
        } else {
          functionReport += custom_testInteractionVariables(true, true, true, true, true, false);
          functionReport += custom_testCustomContextFunctions();
          functionReport += custom_testButtonFunctions();
          functionReport += custom_testDisplayBarMessageFunctions();
        }
        break;
      case "customer-records" :
        idContactTest = true;
      case "interaction-information" :
      case "resources" :
        if (testObject.functions[idxFunction] == "oncustomevent") {
          functionReport += custom_testCustomEvent();
        } else {
          functionReport += custom_testInteractionVariables(true, true, true, true, true, idContactTest);
          functionReport += custom_testCustomContextFunctions();
          functionReport += custom_testTabFunctions(testObject.name);
          functionReport += custom_testDisplayBarMessageFunctions();
        }
        break;
      case "shortcuts":
        functionReport += custom_testShortcutsFunctions();
        functionReport += custom_testCentralPanelFunctions();
        functionReport += custom_testDisplayBarMessageFunctions();
        functionReport += custom_testCustomAreasFunctions();
        break;
    }

    if (functionReport != "")
      testObject.report += custom_formatInformationFunctionMessage(testObject.functions[idxFunction]) + functionReport;

    testObject.functions[idxFunction] = "true";
  }

  return;
}


// displayErrorsReport :
// functions : contains the function name that as not be tested, and true elements for fucntion that has been tested
// report : string containing the errors report to display
// display and returns a string containing the errors report with the function that has not been tested (if any) 
function custom_getErrorsReport(functions, report) {
  var errorsReport = report;
  var nb = functions.length;
  var nbUntested = 0;
  for(var i=0; i<nb; i++) {
    if (functions[i] != "true") {
      if (nbUntested == 0)
        errorsReport += "... MISSING FUNCTIONS ...\n";
      errorsReport += functions[i] + "\n";
      nbUntested ++;
    }
  }
  return errorsReport;
}


function custom_displayErrorsReport(allTests, idxStart, idxEnd) {
  var allReport = "";
  var nbSections = allTests.length;
  if ( (idxStart < nbSections) && (idxEnd < nbSections) ) {
    for(var s=idxStart; s<=idxEnd; s++) {
      allReport += custom_formatInformationSectionMessage(allTests[s].name);
      allReport += custom_getErrorsReport(allTests[s].functions, allTests[s].report);
      allReport += "\n";
    }
    alert(allReport);
  }
}


function custom_displayAllErrorsReport(allTests) {
  var nbSections = allTests.length;
  custom_displayErrorsReport(allTests, 0, nbSections-1);
}


function custom_displayAllErrorsReportInSeveralAlert(allTests) {
  var nbSections = allTests.length;
  custom_displayErrorsReport(allTests, 0, 2);
  custom_displayErrorsReport(allTests, 3, 4);
  custom_displayErrorsReport(allTests, 5, nbSections-1);
}


function custom_displayDesktopErrorsReport(allTests) {
  custom_displayErrorsReport(allTests, 0, 2);
}


function custom_displayInteractionErrorsReport(allTests) {
  var nbSections = allTests.length;
  custom_displayErrorsReport(allTests, 3, nbSections-1);
}



function custom_initTestsInstructionsForm(form, valuesArray) {
  form.elements.step1.value = valuesArray[1];
  form.elements.step2.value = valuesArray[2];
  form.elements.step3.value = valuesArray[3];
  form.elements.step4.value = valuesArray[4];
  form.elements.step5.value = valuesArray[5];
  form.elements.step6.value = valuesArray[6];
  form.elements.step7.value = valuesArray[7];
  form.elements.step8.value = valuesArray[8];
  form.elements.step9.value = valuesArray[9];
}

